// Copyright (c) 2022 FWORKS. All Rights Reserved.

#include "DebugMenuLibraryObjectList.h"
#include "DebugMenuLibraryObjectEditor.h"
#include "DebugMenuManager.h"
#include "EngineUtils.h"
#include "DebugMenuEntry.h"
#include "DebugMenuEntryObjectRef.h"

ADebugMenuLibraryObjectList::ADebugMenuLibraryObjectList()
{

}

void ADebugMenuLibraryObjectList::PerformSearch()
{
	// remove all menu entries
	MenuEntries.Empty();

	if (ClassFilter == nullptr)
	{
		return;
	}

	int32 SearchResultsFound = 0;
	FName LabelObjName;
	UDebugMenuEntryTextLabel* LabelEntry = NewObject<UDebugMenuEntryTextLabel>(this, LabelObjName);
	if (LabelEntry)
	{
		LabelEntry->SetTextLabel("------- Results -------");
		MenuEntries.Add(LabelEntry);
	}

	for (TObjectIterator<UObject> ObjectItr; ObjectItr; ++ObjectItr)
	{
		UObject* Object = *ObjectItr;
		if (Object == nullptr)
		{
			continue;
		}

		if (!Object->IsA(ClassFilter))
		{
			continue;
		}

		if (!IsValid(Object))
		{
			continue;
		}

		SearchResultsFound++;
		
		FName ObjName;
		UDebugMenuEntryObjectRef* NewProp = NewObject<UDebugMenuEntryObjectRef>(this, ObjName);
		if (NewProp)
		{
			NewProp->SetReferencedObject(Object);
			MenuEntries.Add(NewProp);
		}
	}

	if (LabelEntry)
	{
		FString LabelText = ClassFilter->GetName();
		LabelText += " Results: ";
		LabelText += FString::FromInt(SearchResultsFound);
		LabelText += " -------";
		LabelEntry->SetTextLabel(LabelText);
	}
}

void ADebugMenuLibraryObjectList::BeginPlay()
{
	MenuEntries.Empty();

	Super::BeginPlay();
}

void ADebugMenuLibraryObjectList::EndPlay(const EEndPlayReason::Type EndPlayReason)
{
	MenuEntries.Empty();

	Super::EndPlay(EndPlayReason);
}

void ADebugMenuLibraryObjectList::OnLibraryDisplayed()
{		
	PerformSearch();

	Super::OnLibraryDisplayed();
}
