// Copyright (c) 2022 FWORKS. All Rights Reserved.

#include "DebugMenuModule.h"
#include "DebugMenuManager.h"

#define LOCTEXT_NAMESPACE "FDebugMenuModule"

void FDebugMenuModule::StartupModule()
{
	// This code will execute after your module is loaded into memory; the exact timing is specified in the .uplugin file per-module

	ToggleCommand = IConsoleManager::Get().RegisterConsoleCommand(
		TEXT("DebugMenu.Toggle"),
		TEXT("Turns on/off the debug menu"),
		FConsoleCommandWithWorldAndArgsDelegate::CreateLambda(
			[](const TArray< FString >& Args, UWorld* World)
			{
				if (!World)
				{
					return;
				}

				ADebugMenuManager* MenuManager = ADebugMenuManager::GetDebugMenuManager(World);
				if (MenuManager)
				{
					MenuManager->ToggleDebugMenu();
				}
			}
		)
	);
}

void FDebugMenuModule::ShutdownModule()
{
	// This function may be called during shutdown to clean up your module.  For modules that support dynamic reloading,
	// we call this function before unloading the module.
}

#undef LOCTEXT_NAMESPACE
	
IMPLEMENT_MODULE(FDebugMenuModule, DebugMenu)