// Copyright (c) 2022 FWORKS. All Rights Reserved.

#include "DebugMenuWorldSubsystem.h"
#include "DebugMenuSettings.h"
#include "DebugMenuManager.h"
#include "DebugMenuInputHandler.h"
#include "EngineUtils.h"
#include "Engine.h"

void UDebugMenuWorldSubsystem::Initialize(FSubsystemCollectionBase& Collection)
{
#if !UE_BUILD_SHIPPING || defined(FGK_ALLOW_CHEATS_IN_SHIPPING)
	if (UWorld* CurWorld = GetWorld())
	{
		if (CurWorld->IsPlayInEditor() || (!CurWorld->IsEditorWorld() && !CurWorld->IsPreviewWorld()))
		{
			TSubclassOf<ADebugMenuManager> ManagerClass = GetDefault<UDebugMenuSettings>()->DebugMenuManagerRef;
			if (ManagerClass)
			{
				SpawnedManager = GetWorld()->SpawnActor<ADebugMenuManager>(ManagerClass, FTransform::Identity);
			}

			TSubclassOf<ADebugMenuInputHandler> InputHandlerClass = GetDefault<UDebugMenuSettings>()->DebugMenuInputHandlerRef;
			if (InputHandlerClass)
			{
				SpawnedInputHandler = GetWorld()->SpawnActor<ADebugMenuInputHandler>(InputHandlerClass, FTransform::Identity);
			}
		}
		
	}
#endif // !UE_BUILD_SHIPPING

	Super::Initialize(Collection);
}

void UDebugMenuWorldSubsystem::Deinitialize()
{
#if !UE_BUILD_SHIPPING || defined(FGK_ALLOW_CHEATS_IN_SHIPPING)
	if (SpawnedManager)
	{
		SpawnedManager->Destroy();
		SpawnedManager = nullptr;
	}

	if (SpawnedInputHandler)
	{
		SpawnedInputHandler->Destroy();
		SpawnedInputHandler = nullptr;
	}
#endif // !UE_BUILD_SHIPPING

	Super::Deinitialize();
}

ADebugMenuManager* UDebugMenuWorldSubsystem::GetManager() const
{
	return SpawnedManager;
}