// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "Engine/DataAsset.h"
#include "Slate.h"
#include "DebugMenuEntry.h"
#include "DebugMenuTypes.h"
#include "DebugMenuEntryObjectRef.generated.h"

class FDebugMenuListEntryData;
class ADebugMenuManager;

// menu entry that points to a uobject
UCLASS(BlueprintType, DisplayName = "Object Ref Entry", CollapseCategories, EditInlineNew, HideDropdown)
class DEBUGMENU_API UDebugMenuEntryObjectRef : public UDebugMenuEntry
{
	GENERATED_BODY()

public:
	UDebugMenuEntryObjectRef();

	virtual FString GetDisplayString() const override;
	virtual bool OnInputConfirm(TSharedPtr<FDebugMenuListEntryData> RuntimeEntryData, ADebugMenuManager* MenuManager) override;
	virtual FLinearColor GetDisplayColor(TSharedPtr<FDebugMenuListEntryData> RuntimeEntryData, ADebugMenuManager* MenuManager) const override;
	void SetReferencedObject(UObject* NewObj);
	void SetDisplayPrefix(FString InPrefix) { DisplayPrefix = InPrefix; }
	virtual const FSlateBrush* GetBorderImage() const override;
	virtual void OnInputToggleWatch(TSharedPtr<FDebugMenuListEntryData> RuntimeEntryData, ADebugMenuManager* MenuManager) override;
	virtual void OnEntryHighlighted() override;

	TWeakObjectPtr<UObject> TargetObject;
	TFieldPath<FProperty> TargetProperty;
	TArray<FDebugMenuPropertyChain> PropertyChain;

protected:
	TWeakObjectPtr<UObject> ReferencedObject;
	FString DisplayPrefix = "";
};
