// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "DebugMenuLibrary.generated.h"

class UDebugMenuEntry;

UENUM()
enum class EDebugConsoleCommandExecMode : uint8
{
	ExecuteAnywhere,
	ExecuteServerOnly,
	ExecuteClientOnly
};

UCLASS(BlueprintType, Blueprintable)
class DEBUGMENU_API ADebugMenuLibrary : public AActor
{
	GENERATED_BODY()
	
public:	
	ADebugMenuLibrary();

	virtual void BeginPlay() override;
	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

	const TArray<UDebugMenuEntry*>& GetEntries() const;
	const TArray<FName>& GetCategoryHierarchy() const;
	FName GetCategoryDisplayFName() const;
	FString GetCategoryDisplayName() const;

	virtual void OnLibraryDisplayed();
	virtual void OnLibraryExited();

	void NotifyEntriesDisplayEnd();
	void NotifyEntriesDisplayBegin();

	void SetCategoryHierarchy(TArray<FName> NewHierarchy);

	//Will use debug methods to send server only commands from client to server if needed.
	UFUNCTION(BlueprintCallable, Category="DebugMenu Library")
	void ExecuteDebugConsoleCommand(const FString& Command, APlayerController* SpecificPlayer, EDebugConsoleCommandExecMode ExecuteMode);
	
protected:

	// Entries for this menu
	UPROPERTY(Instanced, EditDefaultsOnly, Category="DebugMenu Library")
	TArray<UDebugMenuEntry*> MenuEntries;

	// Where this menu is in the hierarchy. Indicate sublevels by adding to the list
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	TArray<FName> CategoryHierarchy;

	bool bEntriesDisplayed = false;
};
