// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "DebugMenuLibrary.h"
#include "DebugMenuTypes.h"
#include "DebugMenuLibraryObjectEditor.generated.h"

UCLASS(BlueprintType, Blueprintable)
class DEBUGMENU_API ADebugMenuLibraryObjectEditor : public ADebugMenuLibrary
{
	GENERATED_BODY()
	
public:	
	ADebugMenuLibraryObjectEditor();

	virtual void BeginPlay() override;
	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

	virtual void OnLibraryDisplayed() override;
	virtual void OnLibraryExited() override;

	void SetDefaultTargetObject(UObject* NewDefault);
	void SetDestroyLibraryOnExit(bool bDestroy);

	UFUNCTION()
	void OnNameFilterUpdated(FString NewText);

	UFUNCTION()
	void OnDrawDebugLineFromPlayer();

	UFUNCTION()
	void OnDestroyActor();

	void RefreshProperties();
	void CleanupMenuEntries();

protected:


	void CreateMenuEntryForProperty(FProperty* Property, UObject* TargetObj, FString Prefix, TArray<FDebugMenuPropertyChain> PropertyChain, FString NameFilter);

	UFUNCTION(BlueprintNativeEvent, Category="DebugMenu Library")
	UObject* GetTargetObject() const;

	TWeakObjectPtr<UObject> LastDisplayedObject;
	TWeakObjectPtr<UObject> DefaultTargetObject;

	UPROPERTY(Transient)
	FString NameFilter = "";

	// if set, only show properties belonging to these categories
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	TArray<FString> LimitToCategories;

	// sort properties alphabetically
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	bool bSortAlphabetically = true;

	bool bDestroyLibraryOnExit = false;
};
