// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "DebugMenuLibrary.h"
#include "DebugMenuLibraryObjectList.generated.h"

UCLASS(BlueprintType, Blueprintable)
class DEBUGMENU_API ADebugMenuLibraryObjectList : public ADebugMenuLibrary
{
	GENERATED_BODY()
	
public:	
	ADebugMenuLibraryObjectList();

	virtual void BeginPlay() override;
	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

	virtual void OnLibraryDisplayed() override;

	void PerformSearch();

protected:

	// Class to search for
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	TSubclassOf<UObject> ClassFilter;
};
