// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "GameFramework/Actor.h"
#include "DebugMenuLibrary.h"
#include "DebugMenuLibraryObjectSearch.generated.h"

class UInputComponent;

UCLASS(BlueprintType, Blueprintable)
class DEBUGMENU_API ADebugMenuLibraryObjectSearch : public ADebugMenuLibrary
{
	GENERATED_BODY()
	
public:	
	ADebugMenuLibraryObjectSearch();

	virtual void BeginPlay() override;
	virtual void EndPlay(const EEndPlayReason::Type EndPlayReason) override;

	virtual void OnLibraryDisplayed() override;
	virtual void OnLibraryExited() override;

	UFUNCTION()
	void OnClearWatches();

	UFUNCTION()
	void OnMouseClicked();

	UFUNCTION()
	void OnSearchFilterStringUpdated(FString NewText);

	UFUNCTION()
	void OnSearchFilterBoolUpdated(bool NewValue);

	UFUNCTION()
	void OnSearchFilterIntegerUpdated(int32 NewValue);

	void PerformSearch(UObject* SpecificObj = nullptr);

	bool StringMatchesSearch(const FString& CheckString, TArray<FString>& SearchWords, bool bUseExactMatch) const;

protected:

	// Text to search for
	UPROPERTY(Transient)
	FString SearchText = "";

	// Max search results to display
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	int32 MaxSearchResults = 10;

	// Search for matches of the class name, otherwise object name
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	bool bSearchClassName = false;

	// Use exact match for the searched text, otherwise partial match
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	bool bExactMatch = false;

	// Allow clicking on actors in the viewport to fill up the search textbox
	UPROPERTY(EditDefaultsOnly, Category = "DebugMenu Library")
	bool bMousePicker = false;

	UPROPERTY(Transient)
	UInputComponent* ObjSearchInputComponent = nullptr;
};
