// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Engine/DeveloperSettings.h"
#include "DebugMenuSettings.generated.h"

UCLASS(config=Plugins, defaultconfig, meta = (DisplayName = "Debug Menu"))
class DEBUGMENU_API UDebugMenuSettings : public UDeveloperSettings
{
	GENERATED_UCLASS_BODY()

public:
	// Manager to spawn
	UPROPERTY(config, EditAnywhere, Category = "DebugMenu")
	TSubclassOf<ADebugMenuManager> DebugMenuManagerRef;

	// Optional input handler to spawn, leave it blank if you're managing your own input
	UPROPERTY(config, EditAnywhere, Category = "DebugMenu")
	TSubclassOf<ADebugMenuInputHandler> DebugMenuInputHandlerRef;
};