// Copyright (c) 2022 FWORKS. All Rights Reserved.

#pragma once

#include "CoreMinimal.h"
#include "Subsystems/WorldSubsystem.h"
#include "DebugMenuWorldSubsystem.generated.h"

class ADebugMenuManager;
class ADebugMenuInputHandler;

UCLASS(BlueprintType)
class DEBUGMENU_API UDebugMenuWorldSubsystem : public UWorldSubsystem
{
	GENERATED_BODY()
	
public:	
	virtual void Initialize(FSubsystemCollectionBase& Collection) override;
	virtual void Deinitialize() override;

	ADebugMenuManager* GetManager() const;
	
	UPROPERTY(Transient)
	ADebugMenuManager* SpawnedManager = nullptr;

	UPROPERTY(Transient)
	ADebugMenuInputHandler* SpawnedInputHandler = nullptr;
};
